#ifndef PAWNTAB_H
#define PAWNTAB_H

#include "defs.h"
#include "piece.h"

using namespace std;


struct sPawnelem {
       u64 key;
       int wscore[2];//open and end scores
	   int bscore[2];
};

class cPawntable {

private:
         sPawnelem *table;
         uint elements;
         uint write;
         uint probe;
         uint hit;

         void init_table_memory();

         cPawntable( const cPawntable & );
         cPawntable &operator = ( const cPawntable & );

public:
         cPawntable();

         sPawnelem *p2pawn() {return table;}

         void reset_tables();
         void delete_tables();
         void makenewtable(uint elem);

         void setwritten(uint w) { write = w; }
         void setprobe(uint w) { probe = w; }
         uint getwritten() { return write; }
         uint getprobe() { return probe; }
         uint gethit() { return hit; }
         uint getelements() { return elements; }

         void incrwritten() { write++;}
         void incrprobes() { probe++;}
         void incrhit() { hit++;}

         void resetcounters() { hit=probe=write=0;}
         bool probe_pawn(int *wscore, int *bscore, u64 &key);
         void store_pawn(int *wscore, int *bscore, u64 &key);

         void says_stats();

};

#endif
